#version 330 core

uniform float deltaTime;
uniform vec3 force;

layout(lines) in;
layout(points, max_vertices = 1) out;


void main()
{
	vec4 p0 = gl_in[0].gl_Position;
	vec4 p1 = gl_in[1].gl_Position;

	// apply constraints if rest length is > 0
	if ( p1.w > 0.0 )
	{
		vec3 diff = p1.xyz - p0.xyz;
		float len = length(diff);
		diff *= ((len - p1.w) / len) * 0.5;
		p1 += force;
		p1 -= diff*deltaTime;
	}

	gl_Position = p1;
	EmitVertex();
	EndPrimitive();
}
